'use strict';

/* --------------------------------------------------------------
 image_gallery.js 2016-03-09
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2015 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

/**
 * Widget that opens the gallery modal layer (which is
 * used for the article pictures)
 */
gambio.widgets.module('image_gallery_lightbox', [], function (data) {

    'use strict';

    // ########## VARIABLE INITIALIZATION ##########

    var $this = $(this),
        $theme = null,
        module = {};

    // ########## EVENT HANDLER ##########

    // ########## INITIALIZATION ##########

    /**
     * Init function of the widget
     *
     * @constructor
     */
    module.init = function (done) {

        // Delegate lightbox links with Magnific Popup
        // http://dimsemenov.com/plugins/magnific-popup/
        $this.magnificPopup({
            delegate: 'a',
            type: 'image', gallery: {
                enabled: true
            }
        });

        done();
    };

    // Return data to widget engine
    return module;
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
